<?php

return [
    'display_name' => 'Default',
    'preview'      => 'thumb.png',
    'settings'     => [
        'dateAgo' => [
            'type' => 'checkbox',
            'name' => 'dateAgo',
            'label' => 'Display "Last Update" Time as "X Ago"',
            'tooltip' => "Use a simplified format like '2 days ago' instead of showing the exact date and time in the Last Updated column.",
            'tooltip_url' => "https://lagom.rsstudio.net/docs/page-templates/#show-days-ago-format",
        ],
        'hideSidebar' => [
            'type' => 'checkbox',
            'name' => 'hideSidebar',
            'label' => 'Hide Sidebar',
            'tooltip' => "Choose whether you would like to show or hide the content sidebar available on this page.",
        ],
	    'showManageButton' => [
            'type' => 'checkbox',
            'name' => 'showManageButton',
            'label' => 'Show "Manage" Button',
            'tooltip' => "Choose whether you would like to show or hide the \"Manage\" button.",
        ],
        'defaultStatusFilter' => [
            'type' => 'select',
            'name' => 'defaultTicketFilterStatus',
            'label' => 'Default Status Filter ',
            'options' => 'All',
            'default' => 'All',
            'tooltip' => "Choose which ticket statuses will be displayed by default to your customers.",    
        ],
        'hideInactiveTickets' => [
            'type' => 'checkbox',
            'name' => 'hideInactiveTickets',
            'label' => 'Hide Inactive Tickets',
            'tooltip' => "Choose whether you would like to show or hide inactive tickets on this page.",
            'customFormGroupClass' => 'm-b-0x',            
            'dataAttr' => 'data-inactive-services-show',  
        ],
        'hideInactiveTicketsStatus' => [
            'type' => 'multiselect',
            'name' => 'inactiveTicketsStatuses',
            'label' => 'Choose Ticket Statuses Which Should Be Hidden:',
            'options' => '',
            'customFormGroupClass' => 'flex-column is-hidden m-b-0x m-t-2x', 
            'formGroupDataAttr' => 'data-inactive-services-status',           
            'dataAttr' => 'data-inactive-services-status-select',
        ]
    ]
];