<?php

/*
 * ***********************************************
   RS Studio Tickets Hook
   1. Namespaces
   2. Replies Admin Email
   3. View Ticket - New Layout
   4. Ticket date Ago
 * ***********************************************
 */

/*
 * ******************************************
   1. Namespaces
 * ******************************************
 */

use RSThemes\Template\Template;
use RSThemes\Template\Page as TemplatePage;


/*
 * ******************************************
   2. Replies Admin Email
 * ******************************************
 */
add_hook('ClientAreaPageViewTicket', 1, function($vars) {
    if ($vars['templatefile'] == 'viewticket') {
        if (isset($vars['descreplies'])) {
            foreach ($vars['descreplies'] as $key => $reply) {
                if ($reply['admin']) {
                    $admins = \WHMCS\User\Admin::all();
                    foreach ($admins as $admin) {
                        $fullname = $admin->fullname;
                        if ($fullname == $reply['name']) {
                            $vars['descreplies'][$key]['email'] = $admin->email;
                        }
                    }
                }
            }
        }
        return $vars;
    }
});

/*
 * ******************************************
   3. View Ticket - New Layout
 * ******************************************
 */

 add_hook('ClientAreaPageViewTicket', 1, function($vars) {
    if ($vars['templatefile'] == 'viewticket') {
        $ticketId = \Menu::context("ticketId");
        if(!$ticketId) {
            return '';
        }
        $template = new Template($vars['template']);
        $page = new TemplatePage($template, 'viewticket');
        if (isset($page) && $page){
            if (isset($page->getConfiguredOption()->getCustomVariables()['page_layout']) && $page->getConfiguredOption()->getCustomVariables()['page_layout'] == 'new'){
                $ticketData = Menu::context("ticket");

                //Attachments
                $attachments = [];
                $attachmentsChildren = [];
                $allAttachmentsCount = 0;
                if($ticketData["attachment"]) {
                    $attachment = explode("|", $ticketData["attachment"]);
                    $attachmentCount = 0;
                    foreach ($attachment as $filename) {
                        $attachments[] = ["replyid" => 0, "i" => $attachmentCount, "filename" => substr($filename, 7), "removed" => (bool) (int) $ticketData["attachments_removed"]];
                        $attachmentCount++;
                        $allAttachmentsCount++;
                    }
                }
                $result = select_query("tblticketreplies", "", ["tid" => $ticketId], "date", "ASC");
                while ($data = mysql_fetch_array($result)) {
                    if($data["attachment"]) {
                        $attachment = explode("|", $data["attachment"]);
                        $attachmentCount = 0;
                        foreach ($attachment as $filename) {
                            $attachments[] = ["replyid" => $data["id"], "i" => $attachmentCount, "filename" => substr($filename, 7), "removed" => (bool) (int) $data["attachments_removed"]];
                            $attachmentCount++;
                            $allAttachmentsCount++;
                        }
                    }
                }
                if(is_array($attachments) && !empty($attachments)) {
                    foreach ($attachments as $attachment) {
                        if(!$attachment["removed"]) {
                            $uri = "dl.php?type=a&id=" . $ticketNumericId;
                            if(0 < $attachment["replyid"]) {
                                $uri = "dl.php?type=ar&id=" . $attachment["replyid"];
                            }
                            $uri .= "&i=" . $attachment["i"];
                            $attachmentsChildren[] = ["name" => $attachment["filename"], "uri" => $uri];
                        }
                    }
                }

                // CC
                $ticketCcs = $ticketData["cc"];
                $ticketCcs = array_filter(explode(",", $ticketCcs));

                return [
                    'ticketAttachments' => $attachmentsChildren,
                    'ticketAttachmentsCount' => $allAttachmentsCount,
                    'ticketRecipietns' => $ticketCcs,
                ];
            }
        }
        
    }
});

/*
 * ******************************************
   4. Ticket date Ago
 * ******************************************
 */

add_hook('ClientAreaPageSupportTickets', 1, function($vars) {
    $tickets = $vars['tickets'];
    if(is_array($tickets)) {
        foreach ($tickets as $ticket) {
            $ticketsAgo[$ticket['id']]['lastreplyago'] = \RSThemes\Helpers\StringConverter::timeAgoCounter($ticket['normalisedLastReply']);
            $ticketsAgo[$ticket['id']]['dateago'] = \RSThemes\Helpers\StringConverter::timeAgoCounter($ticket['normalisedDate']);
        }
    }

    return ['ticketsAgo' => $ticketsAgo];
});