<?php
/**
 * WHMCS Sample Payment Callback File
 *
 * This sample file demonstrates how a payment gateway callback should be
 * handled within WHMCS.
 *
 * It demonstrates verifying that the payment gateway module is active,
 * validating an Invoice ID, checking for the existence of a Transaction ID,
 * Logging the Transaction for debugging and Adding Payment to an Invoice.
 *
 * For more information, please refer to the online documentation.
 *
 * @see https://developers.whmcs.com/payment-gateways/callbacks/
 *
 * @copyright Copyright (c) WHMCS Limited 2017
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

// Require libraries needed for gateway module functions.
require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

// Detect module name from filename.
$gatewayModuleName = basename(__FILE__, '.php');

// Fetch gateway configuration parameters.
$gatewayParams = getGatewayVariables($gatewayModuleName);

// Die if module is not active.
if (!$gatewayParams['type']) {
    die("Module Not Activated");
}


    logTransaction($gatewayParams['name'], $_REQUEST, "ApgtransactionResponse");
    
        $gatewayParams = getGatewayVariables($gatewayModuleName);
        $systemUrl = $gatewayParams['systemurl'];
        $merchantID  = $gatewayParams['merchant_id'];
        $StoreID  = $gatewayParams['store_id'];
        $GatewayMOde = $gatewayParams['GatewayMOde'];
 
       
        $OrderID = $_GET['O'];
       



        
        
        if ($GatewayMOde == 'Sandbox'){
            
            $url = 'https://sandbox.bankalfalah.com/HS/api/IPN/OrderStatus/'.$merchantID.'/'.$StoreID.'/'.$OrderID;
            
        }elseif($GatewayMOde == 'Live'){
            
            $url = 'https://payments.bankalfalah.com/HS/api/IPN/OrderStatus/'.$merchantID.'/'.$StoreID.'/'.$OrderID;
        }
		
		  
        if(isset($_POST["url"]) ) { 
            
            $url = $_POST["url"];
        }
        
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, true); 
        $result = curl_exec($ch);
        $result = json_decode($result);
        curl_close ($ch);
        $result = json_decode($result);
      
        
        
        $invoiceId = strstr($result->TransactionReferenceNumber, '-', true);               
        $paymentAmount = $result->TransactionAmount;   
   
       
        if ($result->TransactionStatus == 'Paid') {

            
            
        addInvoicePayment(
        $invoiceId,
        $result->TransactionReferenceNumber."<br>".$paymentMethod,
        $paymentAmount,
        0,
        'Alfalah Credit/Debit Card'
        );

           

        }   

  
    

   


header('Location: '.$systemUrl.'viewinvoice.php?id='.$invoiceId);



