<?php

/**
 * WHMCS alfalah Payment Gateway Module
 * Developed by Premium Tech Pakistan
 * https://www.premiumtechs.uk
 * 
if (!defined("WHMCS")) {
	die("This file cannot be accessed directly");
}

/**
 * Define module related meta data.
 *
 * Values returned here are used to determine module related capabilities and
 * settings.
 *
 * @see https://developers.whmcs.com/payment-gateways/meta-data-params/
 *
 * @return array
 */
function alfalah_MetaData()
{
	return array(
		'DisplayName' => 'Alfalah Payment Gateway Module',
		'APIVersion' => '1.1', // Use API Version 1.1
		'DisableLocalCredtCardInput' => false,
		'TokenisedStorage' => false,
	);
}

/**
 * Define gateway configuration options.
 *
 * The fields you define here determine the configuration options that are
 * presented to administrator users when activating and configuring your
 * payment gateway module for use.
 *
 * Supported field types include:
 * * text
 * * password
 * * yesno
 * * dropdown
 * * radio
 * * textarea
 *
 * Examples of each field type and their possible configuration parameters are
 * provided in the sample function below.
 *
 * @return array
 */
function alfalah_config()
{
	return array(
		// the friendly display name for a payment gateway should be
		// defined here for backwards compatibility
		'FriendlyName' => array(
			'Type' => 'System',
			'Value' => 'Alfalah',
		),
		
		// a password field type allows for masked text input
		'merchant_id' => array(
		    'FriendlyName' => 'Merchant ID',
		    'Type' => 'text',
		    'Size' => '100',
		    'Default' => '',
		    'Description' => 'Enter Merchant ID key here',
		),
		'store_id' => array(
		    'FriendlyName' => 'Store ID',
		    'Type' => 'text',
		    'Size' => '21',
		    'Default' => '',
		    'Description' => 'Enter Store ID here',
		),
		'return_url' => array(
		    'FriendlyName' => 'Return Url',
		    'Type' => 'text',
		    'Size' => '100',
		    'Default' => '',
		    'Description' => 'Enter Return Url here',
		),
		'merchant_hash' => array(
		    'FriendlyName' => 'Merchant Hash',
		    'Type' => 'text',
		    'Default' => '100',
		    'Description' => 'Enter Merchant Hash here',
		),
		'merchant_username' => array(
		    'FriendlyName' => 'Merchant Username',
		    'Type' => 'text',
		    'Size' => '255',
		    'Default' => '',
		    'Description' => 'Enter Merchant Username here',
		),
		'merchant_password' => array(
		    'FriendlyName' => 'Merchant Password',
		    'Type' => 'password',
		    'Size' => '255',
		    'Default' => '',
		    'Description' => 'Enter Merchant Password here',
		),
		'key1' => array(
		    'FriendlyName' => 'Key 1',
		    'Type' => 'text',
		    'Size' => '25',
		    'Default' => '',
		    'Description' => 'Enter Key 1 here',
		),
		'key2' => array(
		    'FriendlyName' => 'Key 2',
		    'Type' => 'text',
		    'Size' => '25',
		    'Default' => '',
		    'Description' => 'Enter Key 2 here',
		),
		 'GatewayMOde' => array(
            'FriendlyName' => 'Gateway Mode',
            'Type' => 'dropdown',
            'Options' => array(
                'Sandbox' => 'Sandbox',
                'Live' => 'Live',
            ),
            'Description' => 'Please Select Mode',
        ),
      
        
      


	);
}

/**
 * Payment link.
 *
 * Required by third party payment gateway modules only.
 *
 * Defines the HTML output displayed on an invoice. Typically consists of an
 * HTML form that will take the user to the payment gateway endpoint.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/third-party-gateway/
 *
 * @return string
 */
function alfalah_link($params)
{
 
 
 

$orderID = $params['invoiceid'].'-'.rand(0,241456456);
   
	 
	 if ($params['GatewayMOde'] == "Sandbox"){
		 
		  $url = "https://sandbox.bankalfalah.com/HS/HS/HS";
	 $redirectUrl = "https://sandbox.bankalfalah.com/SSO/SSO/SSO";
	 }else if ($params['GatewayMOde'] == "Live"){
		  $url = "https://payments.bankalfalah.com/HS/HS/HS";
		  $redirectUrl = "https://payments.bankalfalah.com/SSO/SSO/SSO";
	 }
	
        
        $Key1=$params['key1'];
        $Key2= $params['key2'];
        $HS_ChannelId="1001";
        $HS_MerchantId= $params['merchant_id'];
        $HS_StoreId=$params['store_id'];
        $HS_IsRedirectionRequest  = 0;
        $HS_ReturnURL= $params['return_url'];
        $HS_MerchantHash = $params['merchant_hash'];
        $HS_MerchantUsername= $params['merchant_username'];
        $HS_MerchantPassword= $params['merchant_password'];
        $HS_TransactionReferenceNumber= $orderID;
        $transactionTypeId = "3";
	    $TransactionAmount = $params['amount'];   
		$orderID = $params['invoiceid']."-".rand(0,54545454545);
		$cipher="aes-128-cbc";
	   
        $mapString = 
          "HS_ChannelId=$HS_ChannelId" 
        . "&HS_IsRedirectionRequest=$HS_IsRedirectionRequest" 
        . "&HS_MerchantId=$HS_MerchantId" 
        . "&HS_StoreId=$HS_StoreId" 
        . "&HS_ReturnURL=$HS_ReturnURL"
        . "&HS_MerchantHash=$HS_MerchantHash"
        . "&HS_MerchantUsername=$HS_MerchantUsername"
        . "&HS_MerchantPassword=$HS_MerchantPassword"
        . "&HS_TransactionReferenceNumber=$HS_TransactionReferenceNumber";
        
     
        $cipher_text = openssl_encrypt($mapString, $cipher, $Key1,   OPENSSL_RAW_DATA , $Key2);
        $hashRequest = base64_encode($cipher_text);
	        
		
        
        //The data you want to send via POST
        $fields = [
            "HS_ChannelId"=>$HS_ChannelId,
            "HS_IsRedirectionRequest"=>$HS_IsRedirectionRequest,
            "HS_MerchantId"=> $HS_MerchantId,
            "HS_StoreId"=> $HS_StoreId,
            "HS_ReturnURL"=> $HS_ReturnURL,
            "HS_MerchantHash"=> $HS_MerchantHash,
            "HS_MerchantUsername"=> $HS_MerchantUsername,
            "HS_MerchantPassword"=> $HS_MerchantPassword,
            "HS_TransactionReferenceNumber"=> $HS_TransactionReferenceNumber,
            "HS_RequestHash"=> $hashRequest
        ];
        
        $fields_string = http_build_query($fields);
        
        //open connection
        $ch = curl_init();
        //set the url, number of POST vars, POST data
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_POST, true);
        curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
        //So that curl_exec returns the contents of the cURL; rather than echoing it
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, true); 
        //execute post
        $result = curl_exec($ch);
       
       $handshake =  json_decode($result);
       
        $AuthToken = $handshake->AuthToken;
        
       
$RequestHash1 = NULL;
$Currency = "PKR";
$IsBIN =0;

$mapStringSSo = 
  "AuthToken=$AuthToken" 
. "&RequestHash=$RequestHash1" 
. "&ChannelId=$HS_ChannelId"
. "&Currency=$Currency"
. "&IsBIN=$IsBIN"
. "&ReturnURL=$HS_ReturnURL"
. "&MerchantId=$HS_MerchantId"
. "&StoreId=$HS_StoreId" 
. "&MerchantHash=$HS_MerchantHash"
. "&MerchantUsername=$HS_MerchantUsername"
. "&MerchantPassword=$HS_MerchantPassword"
. "&TransactionTypeId=3"
. "&TransactionReferenceNumber=$HS_TransactionReferenceNumber"
. "&TransactionAmount=$TransactionAmount";


		
		 
        $cipher_text = openssl_encrypt($mapStringSSo, $cipher, $Key1,   OPENSSL_RAW_DATA , $Key2);
        $hashRequest1 = base64_encode($cipher_text);
        $htmlOutput .='<form enctype="multipart/form-data" action="'.$redirectUrl.'" id="PageRedirectionForm" method="post">                                                              
     	<input id="AuthToken" name="AuthToken" type="hidden" value="'.$AuthToken.'">                                                                                                                                
     	<input id="RequestHash" name="RequestHash" type="hidden" value="'.$hashRequest1.'">                                                                                                                            
     	<input id="ChannelId" name="ChannelId" type="hidden" value="'.$HS_ChannelId.'">                                                                                                                            
     	<input id="Currency" name="Currency" type="hidden" value="'.$Currency.'">                                                                                                                               
        <input id="IsBIN" name="IsBIN" type="hidden" value="'.$IsBIN.'">                                                                                     
     	<input id="ReturnURL" name="ReturnURL" type="hidden" value="'.$HS_ReturnURL.'">                                                                            
        <input id="MerchantId" name="MerchantId" type="hidden" value="'.$HS_MerchantId.'">                                                                                                                           
        <input id="StoreId" name="StoreId" type="hidden" value="'.$HS_StoreId.'">                                                                                                                     
     	<input id="MerchantHash" name="MerchantHash" type="hidden" value="'.$HS_MerchantHash.'">                                  
     	<input id="MerchantUsername" name="MerchantUsername" type="hidden" value="'.$HS_MerchantUsername.'">                                                                                                            
     	<input id="MerchantPassword" name="MerchantPassword" type="hidden" value="'.$HS_MerchantPassword.'">  
        <input id="TransactionTypeId" name="TransactionTypeId" type="hidden" value="3"> 
        <input autocomplete="off" id="TransactionReferenceNumber" name="TransactionReferenceNumber"type="hidden" value="'.$HS_TransactionReferenceNumber.'">                                  
    	<input autocomplete="off"  id="TransactionAmount" name="TransactionAmount" placeholder="Transaction Amount" type="hidden" value="'.$TransactionAmount.'">  
        <button type="submit" class="btn btn-custon-four btn-danger">PAY </button>                                                                                                 
        </form>';
  
 
	return $htmlOutput;

}


/**
 * Refund transaction.
 *
 * Called when a refund is requested for a previously successful transaction.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/refunds/
 *
 * @return array Transaction response status
 */
function alfalah_refund($params)
{
	return false;
}

/**
 * Cancel subscription.
 *
 * If the payment gateway creates subscriptions and stores the subscription
 * ID in tblhosting.subscriptionid, this function is called upon cancellation
 * or request by an admin user.
 *
 * @param array $params Payment Gateway Module Parameters
 *
 * @see https://developers.whmcs.com/payment-gateways/subscription-management/
 *
 * @return array Transaction response status
 */
function alfalah_cancelSubscription($params)
{
	return false;
	
}
